<?php

namespace App\Http\Livewire\Extensions\GloverWebsite\Livewire;

use App\Models\Order;
use Illuminate\Support\Str;

class OrderDetailsLivewire extends BaseLivewireComponent
{
    public $orderUuid;
    public $order;

    public function mount($uuid)
    {
        $this->orderUuid = $uuid;
        $this->loadOrder();
    }

    public function loadOrder()
    {
        // Find order by matching the generated UUID from order code
        $orders = Order::where('user_id', auth()->id())->get();

        foreach ($orders as $order) {
            if (self::generateUuidFromOrderCode($order->code) === $this->orderUuid) {
                $this->order = $order;
                return;
            }
        }

        // If no order found, redirect to orders page
        abort(404);
    }

    public function generateOrderUuid($orderCode)
    {
        // Generate deterministic UUID v5 based on order code
        $namespace = '6ba7b810-9dad-11d1-80b4-00c04fd430c8'; // DNS namespace
        return Str::orderedUuid()->toString();
    }

    public static function generateUuidFromOrderCode($orderCode)
    {
        // Generate deterministic hash-based UUID from order code
        return substr(md5('order_' . $orderCode), 0, 8) . '-' .
               substr(md5('order_' . $orderCode), 8, 4) . '-' .
               substr(md5('order_' . $orderCode), 12, 4) . '-' .
               substr(md5('order_' . $orderCode), 16, 4) . '-' .
               substr(md5('order_' . $orderCode), 20, 12);
    }

    public function render()
    {
        if (!$this->order) {
            abort(404);
        }

        return view('livewire.extensions.glover-website.order-details', [
            'order' => $this->order
        ])->layout('livewire.extensions.glover-website.layouts.app');
    }
}