<?php

namespace App\Http\Livewire\Extensions\GloverWebsite\Services;

use App\Models\Vendor;
use App\Models\Product;

class WebsiteUrlManagerService
{
    static public function vendorUrl(Vendor $vendor)
    {

        $vendorSlug = \Str::slug($vendor->name);
        if (empty($vendorSlug)) {
            $vendorSlug = \Str::slug($vendor->id);
        }
        if (empty($vendorSlug)) {
            $vendorSlug = \Str::uuid();
        }


        $url = route('glover-website.vendor', [
            'id' => $vendor->id,
            'slug' => $vendorSlug,
        ]);
        return $url;
    }
    static public function productUrl(Product $product)
    {

        $productSlug = \Str::slug($product->name);
        if (empty($productSlug)) {
            $productSlug = \Str::slug($product->id);
        }
        if (empty($productSlug)) {
            $productSlug = \Str::uuid();
        }


        $url = route('glover-website.product', [
            'id' => $product->id,
            'slug' => $productSlug,
        ]);
        return $url;
    }
}