<div>
    @if ($axis == 'horizontal')
        <div class="max-w-full">
            <div class="flex justify-between">
                <p class="text-lg font-medium mb-2">{{ __('Categories') }}</p>
                @if ($categories->hasPages())
                    <a href="{{ route('glover-website.categories', ['vendor_type_id' => $vendorType->id]) }}">
                        <div class="cursor-pointer hover:bg-gray-200 p-2 hover:text-primary-500 flex gap-2 items-center">
                            <x-tabler-eye class="w-4 h-4" />
                            <p class="capitalize text-xs font-medium line-clamp-1 w-full text-ellipsis">
                                {{ __('View all') }}
                            </p>
                        </div>
                    </a>
                @endif
            </div>

            <div class="flex flex-wrap gap-1 md:gap-2 xl:gap-3">
                @foreach ($categories as $category)
                    @php
                        $selected =
                            $category->id == $selectedCategoryId ? 'font-bold text-primary-500 bg-gray-200' : '';
                    @endphp
                    <a href="{{ route('glover-website.search', ['category_id' => $category->id]) }}">
                        <div
                            class="flex items-center gap-2 px-2 py-1 border rounded-full cursor-pointer transition-all hover:bg-gray-100 hover:text-primary-500 {{ $selected }}">
                            <img src="{{ $category->photo }}" alt="{{ $category->name }}"
                                class="hidden md:block w-6 h-6 object-cover" />
                            <p class="capitalize text-xs font-medium">{{ $category->name }}</p>
                        </div>
                    </a>
                @endforeach
            </div>


        </div>
    @else
        <div class='bg-white p-2 px-4 rounded-lg shadow'>
            <p class="text-lg font-medium mb-2">{{ __('Categories') }}</p>
            <div class="gap-2 md:gap-0 md:space-y-2 grid grid-cols-2 md:block">
                @foreach ($categories as $category)
                    @php
                        $selected =
                            $category->id == $selectedCategoryId
                                ? 'font-bold text-primary-500 bg-gray-200 p-2'
                                : 'p-2 md:p-0';
                    @endphp
                    <div>
                        <a href="{{ route('glover-website.search', ['category_id' => $category->id]) }}">
                            <div
                                class="{{ $selected }} cursor-pointer hover:bg-gray-200 hover:px-2 hover:text-primary-500 flex gap-2 items-center">
                                <img src="{{ $category->photo }}" alt="{{ $category->name }}" class="w-6 h-6" />
                                <p class="capitalize text-xs font-medium line-clamp-1 w-full text-ellipsis">
                                    {{ $category->name }}
                                </p>
                            </div>
                        </a>
                    </div>
                @endforeach
                {{-- if categories have more paginate --}}
                @if ($categories->hasPages())
                    <a href="{{ route('glover-website.categories', ['vendor_type_id' => $vendorType->id]) }}">
                        <div
                            class="cursor-pointer hover:bg-gray-200 p-2 hover:text-primary-500 flex gap-2 items-center">
                            <x-tabler-eye class="w-4 h-4" />
                            <p class="capitalize text-xs font-medium line-clamp-1 w-full text-ellipsis">
                                {{ __('View all') }}
                            </p>
                        </div>
                    </a>
                @endif
            </div>
        </div>
    @endif
</div>
