@php
    $bgColor = env('WEBSITE_FOOTER_COLOR', setting('appColorTheme.primaryColor', '#21a179'));
    $average = 381; // range 1 - 765
    if (strlen(trim($bgColor)) == 4) {
        $bgColor =
            '#' .
            substr($bgColor, 1, 1) .
            substr($bgColor, 1, 1) .
            substr($bgColor, 2, 1) .
            substr($bgColor, 2, 1) .
            substr($bgColor, 3, 1) .
            substr($bgColor, 3, 1);
    }
    $isDark =
        hexdec(substr($bgColor, 1, 2)) + hexdec(substr($bgColor, 3, 2)) + hexdec(substr($bgColor, 5, 2)) < $average
            ? true
            : false;
@endphp

<footer class="text-gray-700 font-light py-8" id="footer"
    style="background-color: {{ $bgColor }} !important; color: {{ $isDark ? '#fff' : '#000' }} !important;">
    <div class="py-4 container mx-auto w-full md:w-10/12 lg:w-8/12 flex flex-wrap justify-between gap-4">
        {{-- website name --}}
        <div class="px-5 md:px-0 col-span-2 w-full md:w-4/12">
            <p class="font-bold text-3xl">{{ setting('websiteName', env('APP_NAME')) }}</p>
            @auth
                <p class="">
                    {!! setting('websiteFooterBrief', '') !!}
                </p>
            @else
                <p class="text-lg font-semibold uppercase mt-1">{{ __('News Letter') }}</p>
                <p class="text-sm">{{ __('Subscribe to our newsletter to get latest updatess') }}</p>
                <form action="{{ route('glover-website.register') }}" method="GET"
                    class="my-2 flex border p-0 rounded-xl overflow-clip bg-white text-black">
                    <input type="email" name="email" id="email" placeholder="{{ __('Email Address') }}"
                        class="border-0 flex-1 focus:border-gray-600" />
                    <button type="submit" class="text-center bg-primary-500 flex-none rounded-0 text-theme text-sm px-4">
                        {{ __('Subscribe') }}
                    </button>
                </form>
            @endauth
        </div>
        {{-- download and social media --}}
        <div class="text-left items-start px-5 md:px-0 w-full md:w-4/12 lg:w-3/12">
            <p class="font-semibold text-xl uppercase">{{ __('Download Our Apps') }}</p>
            <div class="mt-1 flex space-x-4 justify-start">
                <a href="{{ setting('androidDownloadLink', '') }}" class="flex items-center">
                    <img src="{{ asset('images/extensions/icons/google-playstore.png') }}" alt="Google Play"
                        class="w-full h-10" />
                </a>
                <a href="{{ setting('iosDownloadLink', '') }}" class="flex items-center">
                    <img src="{{ asset('images/extensions/icons/apple-appstore.png') }}" alt="App Store"
                        class="w-full h-10" />
                </a>
            </div>
            {{-- social medias --}}
            @if (!empty(setting('social.fbLink')) || !empty(setting('social.twLink')) || !empty(setting('social.igLink')))
                <p class="mt-4 font-medium mb-1">{{ __('Follow us on') }}</p>
                <div class="flex items-center gap-4">
                    @if (!empty(setting('social.fbLink')))
                        <a href="{{ setting('social.fbLink') }}" target="_blank">
                            <img src="{{ asset('images/extensions/icons/facebook.png') }}"
                                class="w-10 h-10 text-gray-600" />
                        </a>
                    @endif
                    @if (!empty(setting('social.twLink')))
                        <a href="{{ setting('social.twLink') }}" target="_blank">
                            <img src="{{ asset('images/extensions/icons/twitter.png') }}"
                                class="w-10 h-10 text-gray-600" />
                        </a>
                    @endif
                    @if (!empty(setting('social.igLink')))
                        <a href="{{ setting('social.igLink') }}" target="_blank">
                            <img src="{{ asset('images/extensions/icons/instagram.png') }}"
                                class="w-10 h-10 text-gray-600" />
                        </a>
                    @endif
                </div>
            @endif
        </div>
        {{-- my account --}}
        <div class="px-5 md:px-0">
            <p class="text-sm font-bold underline"> {{ __('My Account') }}</p>
            <div class="mt-1 space-y-3">
                {{-- profile link --}}
                <a href="{{ route('glover-website.profile') }}"
                    class="flex items-center space-x-2 text-xs font-medium hover:underline ">
                    <x-heroicon-o-user class="w-4 h-4 mr-2" />
                    {{ __('Profile') }}
                </a>
                {{-- addresses --}}
                <a href="{{ route('glover-website.addresses') }}"
                    class="flex items-center space-x-2 text-xs font-medium hover:underline ">
                    <x-heroicon-o-globe class="w-4 h-4 mr-2" />
                    {{ __('Addresses') }}
                </a>
                {{-- my orders --}}
                <a href="{{ route('glover-website.orders') }}"
                    class="flex items-center space-x-2 text-xs font-medium hover:underline ">
                    <x-heroicon-o-archive class="w-4 h-4 mr-2" />
                    {{ __('My Orders') }}
                </a>
                {{-- become a seller --}}
                @php
                    if (Route::has('register.vendor')) {
                        $link = route('register.vendor');
                    } else {
                        $link = route('register', ['type' => 'vendor']);
                    }
                @endphp
                <a href="{{ $link }}" target="_blank"
                    class="flex items-center space-x-2 text-xs font-medium hover:underline">
                    <x-heroicon-o-users class="w-4 h-4 mr-2" />
                    {{ __('Become a Seller') }}
                </a>
                {{-- become a delivery personal --}}
                @php
                    if (Route::has('register.vendor')) {
                        $link = route('register.driver');
                    } else {
                        $link = route('register', ['type' => 'driver']);
                    }
                @endphp
                <a href="{{ $link }}" target="_blank"
                    class="flex items-center space-x-2 text-xs font-medium hover:underline">
                    <x-heroicon-o-user class="w-4 h-4 mr-2" />
                    {{ __('Become a Delivery Personal') }}
                </a>

            </div>
        </div>
        {{-- other links --}}
        <div class="px-5 md:px-0">

            <p class="text-sm font-bold underline"> {{ __('Quick Links') }}</p>
            <div class="mt-1 space-y-3">
                {{-- contact us --}}

                <a href="{{ route('contact') }}"
                    class="flex items-center space-x-2 text-xs font-medium hover:underline">
                    <x-heroicon-o-mail class="w-4 h-4 mr-2" />
                    {{ __('Contact Us') }}
                </a>

                {{-- provacy policy --}}

                <a href="{{ route('privacy') }}"
                    class="flex items-center space-x-2 text-xs font-medium hover:underline">
                    <x-heroicon-o-book-open class="w-4 h-4 mr-2" />
                    {{ __('Privacy Policy') }}
                </a>

                {{-- terms and conditions --}}

                <a href="{{ route('terms') }}" class="flex items-center space-x-2 text-xs font-medium hover:underline">
                    <x-heroicon-o-document-text class="w-4 h-4 mr-2" />
                    {{ __('Terms and Conditions') }}
                </a>

                {{-- about us --}}

                <a href="{{ route('contact') }}"
                    class="flex items-center space-x-2 text-xs font-medium hover:underline">
                    <x-heroicon-o-information-circle class="w-4 h-4 mr-2" />
                    {{ __('About Us') }}
                </a>

            </div>

        </div>
    </div>
    <p class="text-xs font-bold text-center py-4 border-t">
        &copy; {{ date('Y') }} {{ config('app.name') }}
    </p>
</footer>

{{-- allow cookies sticky to bottom of the page --}}
<div class="fixed bottom-0 w-full z-50 bg-primary-800 text-theme" id="cookie-banner">
    <div class="w-full md:w-10/12 lg:w-8/12 p-4 flex justify-center items-center mx-auto">
        <div class="">
            <p>
                {{ __('We use cookies to enhance your experience. By using our website, you consent to our use of cookies.') }}
            </p>
        </div>
        {{-- accept btn --}}
        <div class="ltr:ml-4 rtl:mr-4">
            <button
                class="bg-primary-500 hover:bg-primary-600 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline"
                type="button" id="accept-cookies">
                {{ __('Accept') }}
            </button>
        </div>
    </div>
</div>

{{-- scripts --}}
@push('scripts')
    <script>
        function setCookie(name, value, days) {
            var expires = "";
            if (days) {
                var date = new Date();
                date.setTime(date.getTime() + days * 24 * 60 * 60 * 1000);
                expires = "; expires=" + date.toUTCString();
            }
            document.cookie = name + "=" + (value || "") + expires + "; path=/";
        }

        function getCookie(name) {
            var nameEQ = name + "=";
            var ca = document.cookie.split(';');
            for (var i = 0; i < ca.length; i++) {
                var c = ca[i];
                while (c.charAt(0) == ' ') c = c.substring(1, c.length);
                if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
            }
            return null;
        }

        //

        var cookieConsent = getCookie("cookie-consent");
        if (cookieConsent === "accepted") {
            document.getElementById("cookie-banner").style.display = "none";
        } else {
            document.getElementById("accept-cookies").addEventListener("click", function() {
                setCookie("cookie-consent", "accepted", 365);
                document.getElementById("cookie-banner").style.display = "none";
            });
        }
    </script>
@endpush
