@section('title', __('My Orders'))
<div class="mb-20">
    {{-- breadcrumb --}}
    @include('livewire.extensions.glover-website.components.nav-breadcrumb', [
        'links' => [
            [
                'title' => __('Home'),
                'url' => route('glover-website.index'),
            ],
            [
                'title' => __('My Orders'),
                'url' => '',
            ],
        ],
    ])


    {{-- list of order --}}
    <div class="bg-white rounded-sm p-4 shadow-sm border-gray-100">
        {{-- header --}}
        <div class="flex justify-between ">
            <div class="mt-2 mb-4">
                <div class="font-semibold text-lg">{{ __('My Orders') }}</div>
                <div class="text-gray-500 text-sm">{{ __('List of all orders') }}</div>
            </div>
            <div>
                <select name="status" wire:model="status" class="w-40 p-2 border border-gray-300 rounded">
                    <option value="">{{ __('All') }}</option>
                    @foreach (config('backend.colors') as $key => $color)
                        <option value="{{ $key }}">{{ ucfirst($key) }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        @if ($orders->isEmpty())
            <div class="text-center justify-center items-center py-20">
                <x-heroicon-o-information-circle class="w-16 h-16 text-gray-400 mx-auto" />
                <h3 class="text-2xl font-bold">{{ __('No order found') }}</h3>
            </div>
        @else
            <div>

                @foreach ($orders ?? [] as $order)
                    @include('livewire.extensions.glover-website.components.list.order-item', ['order' => $order])
                @endforeach
            </div>
            <div class="my-4">
                {{ $orders->links() }}
            </div>
        @endempty
</div>

</div>
