@section('title', __('Website Setting'))
<div>
    <x-baseview title="{{ __('Website Setting') }}">
        <div class="w-full lg:w-6/12">
            <x-form action='save'>
                <div class="grid grid-cols-2 gap-4">
                    <x-input name="websiteDomain" title="{{ __('Website Domain') }}" />
                    <x-input name="bannerHeight" title="{{ __('Website Banner Height') }}(px)" />
                    <x-input name="popularVendorCount" title="{{ __('Max Number of popular vendor') }}" />
                    <x-input name="campaignProductsCount" title="{{ __('Max Number of campaign product') }}" />
                </div>
                <x-select title="{{ __('Default Language') }}" name="defaultLanguage" :options="$languages" />
                <hr class="my-2" />
                <x-input name="websiteHeaderColor" title="{{ __('Header Color') }}" type="color" />
                <x-input name="websiteFooterColor" title="{{ __('Footer Color') }}" type="color" />
                <hr class="my-2" />
                <div class="mb-4">
                    <x-label title="{{ __('Link/Widget Code/Iframe') }}" />

                    <textarea id="inappSupportCode" wire:model.defer="inappSupportCode"
                        class="w-full h-64 p-2 border border-black rounded-sm"></textarea>
                </div>
                <hr class="my-2" />
                <x-buttons.primary type="submit" title="{{ __('Save') }}" />
            </x-form>
        </div>

    </x-baseview>
</div>
